--> Premire mthode :
DECLARE @UO TABLE(PARAMETRE sysname, VALEUR NVARCHAR(1024));

DECLARE @ISO_LEVEL NVARCHAR(1024);

INSERT @UO EXEC('DBCC USEROPTIONS WITH NO_INFOMSGS');

SELECT VALEUR AS NIVEAU_ISOLATION_COURANT
FROM   @UO
WHERE  PARAMETRE = 'isolation level';

--> Seconde mthode :
SELECT CASE
          WHEN transaction_isolation_level = 1
             THEN 'READ UNCOMMITTED'
          WHEN transaction_isolation_level = 2 AND is_read_committed_snapshot_on = 1
             THEN 'READ COMMITTED SNAPSHOT'
          WHEN transaction_isolation_level = 2 AND is_read_committed_snapshot_on = 0 
		     THEN 'READ COMMITTED'
          WHEN transaction_isolation_level = 3
             THEN 'REPEATABLE READ'
          WHEN transaction_isolation_level = 4
             THEN 'SERIALIZABLE'
          WHEN transaction_isolation_level = 5
             THEN 'SNAPSHOT'
          ELSE NULL
       END AS TRANSACTION_ISOLATION_LEVEL
FROM   sys.dm_exec_sessions AS s
       CROSS JOIN sys.databases AS d
WHERE  session_id = @@SPID
  AND  d.database_id = DB_ID();